<?php
session_start();
include 'conexao.php';

$sql = "SELECT d.data, cf.nome AS categoria, scf.nome AS subcategoria, d.descricao, d.valor, d.origem 
        FROM despesas d
        JOIN categorias_financeiras cf ON d.categoria = cf.id
        JOIN subcategorias_financeiras scf ON d.subcategoria = scf.id
        ORDER BY d.data DESC";

$result = $conn->query($sql);

$total_despesas = 0;
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ver Despesas</title>
    <link rel="stylesheet" href="estilo.css">
    <style>
        <?php include 'estilo_financeiro.css'; ?>
        /* Estilos específicos para esta página */
        .tabela-container {
            overflow-x: auto;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            white-space: nowrap; /* Evita que o texto quebre em várias linhas */
        }
        th {
            background-color: #f2f2f2;
        }
        .total-row {
            font-weight: bold;
            background-color: #e9ecef;
        }
        .pagination {
            margin-top: 20px;
            text-align: center;
        }
        .pagination a {
            color: black;
            padding: 8px 16px;
            text-decoration: none;
            border: 1px solid #ddd;
            margin: 0 4px;
        }
        .pagination a.active {
            background-color: #007bff;
            color: white;
            border: 1px solid #007bff;
        }
    </style>
</head>
<body>

<div class="barra-lateral">
    <a href="painel_financeiro.php">🏠 Início</a>
    <a href="ver_movimentos.php">➕ Movimento</a>
    <a href="registrar_receita.php">💰 Receita</a>
    <a href="registrar_despesa.php">💸 Despesa</a>
    <a href="relatorio_mensal.php">📊 Resumo</a>
</div>

<div class="barra-superior">
    <h2>💸 Registros de Despesas</h2>
</div>

<div class="conteudo">
    <div class="tabela-container">
        <table>
            <thead>
                <tr>
                    <th>Data</th>
                    <th>Categoria</th>
                    <th>Subcategoria</th>
                    <th>Descrição</th>
                    <th>Valor (Kz)</th>
                    <th>Origem / Observações</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($result->num_rows > 0): ?>
                    <?php while ($row = $result->fetch_assoc()): ?>
                        <?php $total_despesas += $row['valor']; ?>
                        <tr>
                            <td><?= date('d/m/Y', strtotime($row['data'])) ?></td>
                            <td><?= htmlspecialchars($row['categoria']) ?></td>
                            <td><?= htmlspecialchars($row['subcategoria']) ?></td>
                            <td><?= htmlspecialchars($row['descricao']) ?></td>
                            <td><?= number_format($row['valor'], 2, ',', '.') ?></td>
                            <td><?= htmlspecialchars($row['origem']) ?></td>
                        </tr>
                    <?php endwhile; ?>
                    <tr class="total-row">
                        <td colspan="4">Total Geral</td>
                        <td><?= number_format($total_despesas, 2, ',', '.') ?></td>
                        <td></td>
                    </tr>
                <?php else: ?>
                    <tr>
                        <td colspan="6">Nenhuma despesa encontrada.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <button onclick="window.location.href='registrar_despesa.php'">💸 Nova Despesa</button>
</div>

</body>
</html>